<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Install extends CI_Controller{	
	var $ldap_ous_to_add = array( 'distribution lists' => LDAP_DISTRUBUTION_LIST_DN,
							      'deleted distribution lists' => LDAP_DELETED_DISTRUBUTION_LIST_DN );

	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt'));
		$this->load->helper('url');
	}
	public function index() {
		$this->load_install_view(); //index view of install controller
	}
	
	
	
	
	public function create_db() {
		$sa_name = $this->input->post('sa_name',TRUE);
		$sa_pwd = $this->input->post('sa_pwd',TRUE);
		$sa_db_config = array(
			'hostname' => DATABASE_HOSTNAME,
			'username' => $sa_name,
			'password' => $sa_pwd,
			'database' => 'direct',
			'dbdriver' => DATABASE_DRIVER,
		);
		$database = $this->load->database($sa_db_config, true);
		
		//update contacts
		$database->query("
			use [direct];
			/****** Object:  Index [PK_contacts]    Script Date: 11/15/2013 07:15:12 ******/
			IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND name = N'PK_contacts')
			ALTER TABLE [dbo].[contacts] DROP CONSTRAINT [PK_contacts]
			/****** Object:  Index [PK_contacts]    Script Date: 11/15/2013 07:17:11 ******/
			ALTER TABLE [dbo].[contacts] ADD  CONSTRAINT [PK_contacts] PRIMARY KEY NONCLUSTERED 
			(
				[contact_id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			/****** Object:  Index [IX_contact_user]    Script Date: 11/15/2013 07:17:21 ******/
			CREATE CLUSTERED INDEX [IX_contact_user] ON [dbo].[contacts] 
			(
				[user_id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			ALTER TABLE [dbo].[contacts]  WITH CHECK ADD  CONSTRAINT [FK_contacts_users] FOREIGN KEY([user_id])
			REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[contacts] CHECK CONSTRAINT [FK_contacts_users]
		");
		//create distribution_list
		$database->query("
			use [direct];
			/****** Object:  Table [dbo].[distribution_lists]    Script Date: 11/15/2013 07:42:18 ******/
			SET ANSI_NULLS ON
			SET QUOTED_IDENTIFIER ON
			SET ANSI_PADDING ON
			CREATE TABLE [dbo].[distribution_lists](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[name] [varchar](max) NOT NULL,
				[description] [varchar](max) NULL,
				[created_by] [bigint] NOT NULL,
				[created_at] [bigint] NOT NULL,
				[modified_at] [bigint] NOT NULL,
				[addresses] [varchar](max) NOT NULL default '',
			 CONSTRAINT [PK_distribution_lists] PRIMARY KEY NONCLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			SET ANSI_PADDING OFF
			ALTER TABLE [dbo].[distribution_lists]  WITH CHECK ADD  CONSTRAINT [FK_user] FOREIGN KEY([created_by])
			REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[distribution_lists] CHECK CONSTRAINT [FK_user]
			/****** Object:  Index [IX_distribution_lists]    Script Date: 11/15/2013 07:43:56 ******/
			CREATE CLUSTERED INDEX [IX_distribution_lists] ON [dbo].[distribution_lists] 
			(
				[created_by] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
		");
		//create distro_members
		/*$database->query("
			use [direct];
			SET ANSI_NULLS ON
			SET QUOTED_IDENTIFIER ON
			CREATE TABLE [dbo].[distro_members](
				[distribution_id] [bigint] NOT NULL,
				[user_id] [bigint] NOT NULL,
			 CONSTRAINT [PK_distro_members] PRIMARY KEY CLUSTERED 
			(
				[distribution_id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			ALTER TABLE [dbo].[distro_members]  WITH CHECK ADD  CONSTRAINT [FK_dirtribution_id] FOREIGN KEY([distribution_id])
			REFERENCES [dbo].[distribution_lists] ([id])
			ON DELETE CASCADE
			ALTER TABLE [dbo].[distro_members] CHECK CONSTRAINT [FK_dirtribution_id]
			ALTER TABLE [dbo].[distro_members]  WITH CHECK ADD  CONSTRAINT [FK_user_id] FOREIGN KEY([user_id])
			REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[distro_members] CHECK CONSTRAINT [FK_user_id]
		");*/
		//add message flags
		$database->query("
			use [direct];
			SET ANSI_NULLS ON
			SET QUOTED_IDENTIFIER ON
			SET ANSI_PADDING ON
			ALTER TABLE Users ADD UNIQUE (user_name)
			CREATE TABLE [dbo].[flags](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[color] [varchar](50) NULL,
				[content] [varchar](max) NULL,
				[mailbox_group] [nvarchar](50) NOT NULL,
				[created_by] [bigint] NOT NULL,
				[modified_by] [bigint] NOT NULL,
				[created_at] [bigint] NOT NULL,
				[modified_at] [bigint] NOT NULL,
			 CONSTRAINT [PK_flag] PRIMARY KEY NONCLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			SET ANSI_PADDING OFF
			ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_created_by] FOREIGN KEY([created_by])
			REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_created_by]
			ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_modified_by] FOREIGN KEY([modified_by])
			REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_modified_by]
			/****** Object:  Index [IX_flags]    Script Date: 11/15/2013 07:43:56 ******/
			CREATE CLUSTERED INDEX [IX_flags] ON [dbo].[flags] 
			(
				[created_by] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
		");
		//workflow items
		$database->query("
			use [direct];
			SET ANSI_NULLS ON
			SET QUOTED_IDENTIFIER ON
			SET ANSI_PADDING ON
			CREATE TABLE [dbo].[workflow_items](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[mailbox_group] [nvarchar](50) NOT NULL,
				[assigned_to] [bigint],
				[complete] [tinyint] NOT NULL DEFAULT 0,
				[created_by] [bigint] NOT NULL,
				[modified_by] [bigint] NOT NULL,
				[created_at] [bigint] NOT NULL,
				[modified_at] [bigint] NOT NULL,
			 CONSTRAINT [PK_workflow_flag] PRIMARY KEY NONCLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			SET ANSI_PADDING OFF
			ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_mailbox_group] 	
				FOREIGN KEY([mailbox_group])
				REFERENCES [dbo].[users] ([user_name])
			ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_mailbox_group]
			ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_assigned_to] 	
				FOREIGN KEY([assigned_to])
				REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_assigned_to]
			ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_created_by] 	
				FOREIGN KEY([created_by])
				REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_created_by]
			ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_modified_by] 
				FOREIGN KEY([modified_by])
				REFERENCES [dbo].[users] ([user_id])
			ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_modified_by]
		");
		
		$db_status = $this->check_db_configuration();
		if($db_status['status'] === FALSE) {
			$this->output->append_output('<h2>Failed to create database tables</h2>');
		}
		else{
			$this->output->append_output('<h2>Database Tables Created</h2>');
		}
		$this->output->append_output('<br/><a href="/install">Return</a>');
	}
	private function load_install_view() {
		$this->load->helper("form_helper");
		$data['title'] = 'VLER Direct: Update';
		$db_status = $this->check_db_configuration();
		if($db_status['status'] === FALSE) {
			$this->output->append_output('<div>'.$db_status['message'].'</div>');
			$this->output->append_output(form_open('/install/create_db'));
			$this->output->append_output('<table class="form" style="float: none;">');
			$this->output->append_output('<tr><td><label for="sa_name">Database SA</label></td><td><input type="text" id="sa_name" name="sa_name" /></td></tr>');
			$this->output->append_output('<tr><td><label for="sa_pwd">Database SA Password</label></td><td><input type="password" id="sa_pwd" name="sa_pwd" /></td></t>');
			$this->output->append_output('</table>');
			$this->output->append_output('<div class="center"><input type="submit" value="Create Database Tables"/></div>');
			$this->output->append_output(form_close());
		}
		else{
			$this->output->append_output('<h2>Database <span style="color: green;">&#x2713;</span></h2>');
		}
		$ldap_status = $this->check_ldap_configuration();
		if($ldap_status['status'] === FALSE) {
			$this->output->append_output('<div>'.$ldap_status['message'].'</div>');
			$this->output->append_output(form_open('/install/create_ldap'));
			$this->output->append_output('<div class="form" style="float: none;">');
			$this->output->append_output('<label for="sa_name">LDAP admin password</label><input type="password" id="ldap_pwd" name="ldap_pwd" /><br /><br />');
			$this->output->append_output('</div>');
			$this->output->append_output('<div class="center"><input type="submit" value="Create LDAP Entry"/></div>');
			$this->output->append_output(form_close());
		}
		else{
			$this->output->append_output('<h2>LDAP <span style="color: green;">&#x2713;</span></h2>');
		}
	}
	private function check_db_configuration() {
		$status = TRUE;
		$output = '';
		//test database connection
		$db = $this->load->database('default',TRUE);
		if(FALSE === $db->conn_id) {
			$output .= '<div class="message_error"><ul>';
			$error_output = '';
			$errors = sqlsrv_errors();
			foreach($errors as $error) { $error_output .= $error['message']; }
			preg_match_all("/Cannot open database \"(.*)?\" requested by the login/",$error_output,$matches);
			if($matches[1][0] === DATABASE_NAME) {
				$output .= '<li>Configured database "'.DATABASE_NAME . '" does not exist yet.</li>';
			}
			$status = FALSE;
		}
		else {
			$output .= '<div class="message_success"><ul>';
			$output .= '<li>Configured database "'.DATABASE_NAME . '" exists.</li></ul></div>';
			$tables = array(/*'distro_members',*//*'distribution_lists',*/ 'flags', 'workflow_items', 'workflow_log');
			$table_errors = ''; $table_success = '';
			foreach($tables as $table) {
				$tbl_check = $db->query('SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='.$db->escape('BASE TABLE').' AND TABLE_NAME='.$db->escape($table));
				if($tbl_check) {
					if($tbl_check->num_rows() <= 0) { 
						$table_errors .= '<li>Table ' . $table . ' does not exist yet.</li>'; 
					}
					else {
						$table_success .= '<li>Table ' . $table . ' exists.</li>'; 
					}
				}
				else {
					$table_errors .= '<li>Could not get status for table ' . $table . '. Possible permissions issue.</li>'; 
				}
			}
			if(strlen($table_success) > 0) {
				$output .= '<div class="message_success"><ul>';
				$output .= $table_success;
				$output .= '</ul></div>';
			}
			
			if(strlen($table_errors) > 0) {
				$output .= '<div class="message_error"><ul>';
				$output .= $table_errors;
				$status = FALSE;
			}
		}
		return array('message'=>$output .'</ul></div>','status'=>$status);
	 }
	public function create_ldap() {
		$ldap_pwd = $this->input->post('ldap_pwd',TRUE);
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, "cn=admin,".LDAP_BASE_DOMAIN, $ldap_pwd);
		
		if($ldap_bind) {			
			foreach($this->ldap_ous_to_add as $description => $dn){	
				if($this->ldap_entry_exists($ldap_conn,$dn)){
					$this->output->append_output('<div>'.$description.' already exists in LDAP; skipping.</div>');
					continue;
				}	
			
				$dn_exp = ldap_explode_dn($dn,1);
				$distro_attrs = array(
					'objectClass' => array('organizationalUnit','top'),
					'ou' => $dn_exp[0],
				);
				$add = ldap_add($ldap_conn,$dn,$distro_attrs);
				if(!$add){
					$this->output->append_output('<div>Failed to create '.$description.'</div>');
				}
				else{
					$this->output->append_output('<div>Success!  Created  '.$description.' in LDAP.</div>');
				}
			}
		}else{
			$this->output->append_output('<div>Failed to connect to ldap</div>');
		}
		$this->output->append_output('<br/><a href="/install">Return</a>');		
	}
	private function check_ldap_configuration() {
		$output = '';
		$status = FALSE;
		//if we get to this point, the configuration should be set enough to do a bind as the admin user
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_SEARCH_USERNAME, LDAP_SEARCH_PASSWORD);
		if($ldap_bind) {
			$ldap_is_configured = true;
			foreach($this->ldap_ous_to_add as $description => $dn){
				if(!$this->ldap_entry_exists($ldap_conn,$dn)) {
					$ldap_is_configured = false;
					$output .= '<p>'.ucfirst($description).' entry does not exist.</p>';
				}
			}
		}
		else {
			$output .= 'Failed to connect to LDAP';
		}
		return array('message'=>$output,'status'=>$status);
	 }
	 private function ldap_entry_exists($ldap_conn,$dn) {
		$search = @ldap_search($ldap_conn, $dn, '(objectClass=*)');
		$result = @ldap_get_entries($ldap_conn,$search);
		if($result['count'] > 0) { return TRUE; }
		return FALSE;
	}
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
	
}